package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.Proyectista;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0483s00DaoImpl generated by UDA, 16-feb-2017 9:14:37.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ProyectistaDaoImpl implements ProyectistaDao {
	private JdbcTemplate jdbcTemplate;

	private static final String SELECT_QUERY = "SELECT t1.TEREXP_083 TEREXP083, t1.ANOEXP_083 ANOEXP083, t1.NUMEXP_083 NUMEXP083, t1.TIPDOC_083 TIPDOC083, t1.NUMDOC_083 NUMDOC083, t1.FECALT_083 FECALT083, t1.CODOBRA_083 CODOBRA083, t1.FECBAJ_083 FECBAJ083, t1.NOMPRY_083 NOMPRY083, t1.PAISPRY_083 PAISPRY083, t1.PRVPRY_083 PRVPRY083, t1.MUNPRY_083 MUNPRY083, t1.DMUNPRY_083 DMUNPRY083, t1.DIRPRY_083 DIRPRY083, t1.CPOPRY_083 CPOPRY083, t1.ORDEXP_083 ORDEXP083, t1.USUALT_083 USUALT083, t1.FECMOD_083 FECMOD083, t1.USUMOD_083 USUMOD083, t1.DESCPRY_083 DESCPRY083,t1.TLFPRY_083 TLFPRY083,t1.EMAILPRY_083 EMAILPRY083, "
			+ " PROVINCIA.ID ID_PROVINCIA, PROVINCIA.DS_O PROVINCIA, MUNICIPIO.ID ID_MUNICIPIO, MUNICIPIO.DS_O MUNICIPIO "
			+ "FROM AB0483S00 t1 LEFT OUTER JOIN PROVINCIA ON (ID = t1.PRVPRY_083) LEFT OUTER JOIN MUNICIPIO ON (MUNICIPIO.PROVINCIA_ID = t1.PRVPRY_083 AND MUNICIPIO.ID = t1.MUNPRY_083) ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Proyectista> rwMap = new RowMapper<Proyectista>() {
		public Proyectista mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Proyectista proyecRet = new Proyectista(
					resultSet.getString("TEREXP083"),
					resultSet.getString("ANOEXP083"),
					resultSet.getInt("NUMEXP083"),
					resultSet.getString("TIPDOC083"),
					resultSet.getString("NUMDOC083"),
					resultSet.getDate("FECALT083"),
					resultSet.getLong("CODOBRA083"),
					resultSet.getDate("FECBAJ083"),
					resultSet.getString("NOMPRY083"),
					resultSet.getString("PAISPRY083"),
					resultSet.getString("PRVPRY083"),
					resultSet.getString("MUNPRY083"),
					resultSet.getString("DMUNPRY083"),
					resultSet.getString("DIRPRY083"),
					resultSet.getString("CPOPRY083"),
					resultSet.getLong("ORDEXP083"),
					resultSet.getString("USUALT083"),
					resultSet.getDate("FECMOD083"),
					resultSet.getString("USUMOD083"),
					resultSet.getString("DESCPRY083"),
					resultSet.getString("TLFPRY083"),
					resultSet.getString("EMAILPRY083"));

			if (UtilDAO.hasColumn(resultSet, "ID_PROVINCIA")) {
				Provincia prov = new Provincia();
				prov.setCodProvincia(resultSet.getString("ID_PROVINCIA"));
				prov.setDescripcion(resultSet.getString("PROVINCIA"));
				proyecRet.setProvincia(prov);
			}

			if (UtilDAO.hasColumn(resultSet, "ID_MUNICIPIO")) {
				Municipio munic = new Municipio();
				munic.setCodMunicipio(resultSet.getString("ID_MUNICIPIO"));
				munic.setDescripcion(resultSet.getString("MUNICIPIO"));
				proyecRet.setMunicipio(munic);
			}

			return proyecRet;
		}
	};

	private RowMapper<Proyectista> rwMapPK = new RowMapper<Proyectista>() {
		public Proyectista mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Proyectista(resultSet.getString("TEREXP083"),
					resultSet.getString("ANOEXP083"),
					resultSet.getInt("NUMEXP083"),
					resultSet.getString("TIPDOC083"),
					resultSet.getString("NUMDOC083"),
					resultSet.getDate("FECALT083"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
 dataSource
	 *            DataSource

	 */
	private RowMapper<JerarquiaDto<Proyectista>> rwMapJerarquia = new RowMapper<JerarquiaDto<Proyectista>>() {
		public JerarquiaDto<Proyectista> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Proyectista ab0483s00 = new Proyectista(
					resultSet.getString("TEREXP083"),
					resultSet.getString("ANOEXP083"),
					resultSet.getInt("NUMEXP083"),
					resultSet.getString("TIPDOC083"),
					resultSet.getString("NUMDOC083"),
					resultSet.getDate("FECALT083"),
					resultSet.getLong("CODOBRA083"),
					resultSet.getDate("FECBAJ083"),
					resultSet.getString("NOMPRY083"),
					resultSet.getString("PAISPRY083"),
					resultSet.getString("PRVPRY083"),
					resultSet.getString("MUNPRY083"),
					resultSet.getString("DMUNPRY083"),
					resultSet.getString("DIRPRY083"),
					resultSet.getString("CPOPRY083"),
					resultSet.getLong("ORDEXP083"),
					resultSet.getString("USUALT083"),
					resultSet.getDate("FECMOD083"),
					resultSet.getString("USUMOD083"),
					resultSet.getString("DESCPRY083"),
					resultSet.getString("TLFPRY083"),
					resultSet.getString("EMAILPRY083"));

			JerarquiaDto<Proyectista> jerarquia = new JerarquiaDto<Proyectista>();
			jerarquia.setModel(ab0483s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	public Proyectista add(Proyectista ab0483s00) {
		String query = "INSERT INTO AB0483S00 (TEREXP_083, ANOEXP_083, NUMEXP_083, TIPDOC_083, NUMDOC_083, CODOBRA_083, FECBAJ_083, NOMPRY_083, PAISPRY_083, PRVPRY_083, MUNPRY_083, DMUNPRY_083, DIRPRY_083, CPOPRY_083, ORDEXP_083, USUALT_083, DESCPRY_083, FECALT_083,TLFPRY_083,EMAILPRY_083) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?,?)";
		this.jdbcTemplate.update(query, ab0483s00.getTerexp083(),
				ab0483s00.getAnoexp083(), ab0483s00.getNumexp083(),
				ab0483s00.getTipdoc083(), ab0483s00.getNumdoc083(),
				ab0483s00.getCodobra083(), ab0483s00.getFecbaj083(),
				ab0483s00.getNompry083(), ab0483s00.getPaispry083(),
				(ab0483s00.getCodProvincia() != null)
						? ab0483s00.getCodProvincia()
						: ab0483s00.getPrvpry083(),
				(ab0483s00.getCodMunicipio() != null)
						? ab0483s00.getCodMunicipio()
						: ab0483s00.getMunpry083(),
				ab0483s00.getDmunpry083(), ab0483s00.getDirpry083(),
				ab0483s00.getCpopry083(), ab0483s00.getOrdexp083(),
				ab0483s00.getUsualt083(), ab0483s00.getDescpry083(),
				ab0483s00.getTlfpry083(), ab0483s00.getEmailpry083());
		return ab0483s00;
	}

	/**
	 * Inserts a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	public Proyectista addFromSolicitud(Proyectista ab0483s00) {
		String query = "INSERT INTO AB0483S00 (TEREXP_083, ANOEXP_083, NUMEXP_083, TIPDOC_083, NUMDOC_083, CODOBRA_083, FECBAJ_083, NOMPRY_083, PAISPRY_083, "
				+ "PRVPRY_083, MUNPRY_083, DMUNPRY_083, DIRPRY_083, CPOPRY_083, ORDEXP_083, USUALT_083, DESCPRY_083, FECALT_083,TLFPRY_083,EMAILPRY_083) "
				+ "(SELECT ?, ?, ?, TIPDOC_083, NUMDOC_083, CODOBRA_083, FECBAJ_083, NOMPRY_083, PAISPRY_083, PRVPRY_083, MUNPRY_083, "
				+ "DMUNPRY_083, DIRPRY_083, CPOPRY_083, ORDEXP_083, USUALT_083, DESCPRY_083, SYSDATE,TLFPRY_083,EMAILPRY_083 from AB0483S01 where CODOBRA_083 = ? )";
		this.jdbcTemplate.update(query, ab0483s00.getTerexp083(),
				ab0483s00.getAnoexp083(), ab0483s00.getNumexp083(),
				ab0483s00.getCodobra083());
		return ab0483s00;
	}

	/**
	 * Updates a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	public Proyectista update(Proyectista ab0483s00) {
		String query = "UPDATE AB0483S00 SET NOMPRY_083=?, PAISPRY_083=?, PRVPRY_083=?, MUNPRY_083=?, DMUNPRY_083=?, DIRPRY_083=?, CPOPRY_083=?, ORDEXP_083=?, FECMOD_083=?, USUMOD_083=?, DESCPRY_083=? WHERE TEREXP_083=? AND ANOEXP_083=? AND NUMEXP_083=? AND TIPDOC_083=? AND NUMDOC_083=? AND CODOBRA_083=? AND TLFPRY_083=? AND EMAILPRY_083=?";
		this.jdbcTemplate.update(query, ab0483s00.getNompry083(),
				ab0483s00.getPaispry083(),
				(ab0483s00.getProvincia() != null
						&& ab0483s00.getCodProvincia() != null)
								? ab0483s00.getCodProvincia()
								: ab0483s00.getPrvpry083(),
				(ab0483s00.getMunicipio() != null
						&& ab0483s00.getCodMunicipio() != null)
								? ab0483s00.getCodMunicipio()
								: ab0483s00.getMunpry083(),
				ab0483s00.getDmunpry083(), ab0483s00.getDirpry083(),
				ab0483s00.getCpopry083(), ab0483s00.getOrdexp083(),
				ab0483s00.getFecmod083(), ab0483s00.getUsumod083(),
				ab0483s00.getDescpry083(), ab0483s00.getTerexp083(),
				ab0483s00.getAnoexp083(), ab0483s00.getNumexp083(),
				ab0483s00.getTipdoc083(), ab0483s00.getNumdoc083(),
				ab0483s00.getCodobra083(), ab0483s00.getTlfpry083(),
				ab0483s00.getEmailpry083());
		return ab0483s00;
	}

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	@Transactional(readOnly = true)
	public Proyectista find(Proyectista ab0483s00) {
		StringBuilder select = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		select.append(ProyectistaDaoImpl.SELECT_QUERY);
		select.append(
				"WHERE t1.TEREXP_083 = ?   AND t1.ANOEXP_083 = ?   AND t1.NUMEXP_083 = ?   AND t1.TIPDOC_083 = ?   AND t1.NUMDOC_083 = ? ");

		List<Proyectista> ab0483s00List = this.jdbcTemplate.query(
				select.toString(), this.rwMap, ab0483s00.getTerexp083(),
				ab0483s00.getAnoexp083(), ab0483s00.getNumexp083(),
				ab0483s00.getTipdoc083(), ab0483s00.getNumdoc083());
		return (Proyectista) DataAccessUtils.uniqueResult(ab0483s00List);
	}

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Proyectista> findProyectistaMaxFecAlta(Proyectista ab0483s00) {
		StringBuilder select = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		select.append(ProyectistaDaoImpl.SELECT_QUERY);
		select.append("WHERE t1.TIPDOC_083 = ? AND t1.NUMDOC_083 = ? ");
		select.append("ORDER BY t1.FECALT_083 DESC");

		return (List<Proyectista>) this.jdbcTemplate.query(select.toString(),
				this.rwMap, ab0483s00.getTipdoc083(), ab0483s00.getNumdoc083());
	}

	/**
	 * Removes a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00            Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 */
	public void remove(Proyectista ab0483s00) {
		String query = "DELETE FROM AB0483S00 WHERE TEREXP_083=? AND ANOEXP_083=? AND NUMEXP_083=? AND TIPDOC_083=? AND NUMDOC_083=? AND CODOBRA_083=?";

		this.jdbcTemplate.update(query, ab0483s00.getTerexp083(),
				ab0483s00.getAnoexp083(), ab0483s00.getNumexp083(),
				ab0483s00.getTipdoc083(), ab0483s00.getNumdoc083(),
				ab0483s00.getCodobra083());
	}

	/**
	 * Finds a list of rows in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0483s00>
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Proyectista> findAll(Proyectista ab0483s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder select = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		select.append(ProyectistaDaoImpl.SELECT_QUERY);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0483s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		select.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			select = JQGridManager.getPaginationQuery(jqGridRequestDto, select);
		}

		return (List<Proyectista>) this.jdbcTemplate.query(select.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0483s00 table using like.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0483s00>
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Proyectista> findAllLike(Proyectista ab0483s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		query.append(ProyectistaDaoImpl.SELECT_QUERY);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0483s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Proyectista>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Long
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Proyectista ab0483s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0483S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0483s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0483s00 table using like.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Proyectista ab0483s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0483S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0483s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0483s00 selected for rup_table.
	 * 
	 *  ab0483s00            Ab0483s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0483s00>>
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Proyectista>> reorderSelection(
			Proyectista ab0483s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		query.append(ProyectistaDaoImpl.SELECT_QUERY);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0483s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Proyectista.class, filterParamList,
				"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Proyectista>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0483s00
	 *  searchParams            Ab0483s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0483s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Proyectista>> search(Proyectista filterParams,
			Proyectista searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		query.append(ProyectistaDaoImpl.SELECT_QUERY);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Proyectista.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Proyectista>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0483s00            Ab0483s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0483s00 the filterab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override()
	public void removeMultiple(Proyectista filterab0483s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		query.append(ProyectistaDaoImpl.SELECT_QUERY);

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0483s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Proyectista.class,
						query, params,
						"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<JerarquiaDto<Ab0483s00>>
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override()
	public List<JerarquiaDto<Proyectista>> findAllLikeJerarquia(
			Proyectista filterAb0483s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TEREXP_083 TEREXP083,t1.ANOEXP_083 ANOEXP083,t1.NUMEXP_083 NUMEXP083,t1.TIPDOC_083 TIPDOC083,t1.NUMDOC_083 NUMDOC083,t1.FECALT_083 FECALT083,t1.CODOBRA_083 CODOBRA083,t1.FECBAJ_083 FECBAJ083,t1.NOMPRY_083 NOMPRY083,t1.PAISPRY_083 PAISPRY083,t1.PRVPRY_083 PRVPRY083,t1.MUNPRY_083 MUNPRY083,t1.DMUNPRY_083 DMUNPRY083,t1.DIRPRY_083 DIRPRY083,t1.CPOPRY_083 CPOPRY083,t1.ORDEXP_083 ORDEXP083,t1.USUALT_083 USUALT083,t1.FECMOD_083 FECMOD083,t1.USUMOD_083 USUMOD083,t1.DESCPRY_083 DESCPRY083 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0483S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0483S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0483s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere,
				"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083",
				"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterAb0483s00            Ab0483s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  Long
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	@Override()
	public Long findAllLikeCountJerarquia(Proyectista filterAb0483s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0483S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0483S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0483s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterAb0483s00            Ab0483s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  List<TableRowDto<Ab0483s00>>
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Proyectista>> findAllChild(
			Proyectista filterAb0483s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0483S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0483S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0483s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Proyectista>(this.rwMapPK,
						"TEREXP_083,ANOEXP_083,NUMEXP_083,TIPDOC_083,NUMDOC_083,FECALT_083"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0483s00 entity.
	 * 
	 *  ab0483s00            Ab0483s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Proyectista ab0483s00) {

		StringBuilder where = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0483s00 != null && ab0483s00.getTerexp083() != null) {
			where.append(" AND t1.TEREXP_083 = ?");
			params.add(ab0483s00.getTerexp083());
		}
		if (ab0483s00 != null && ab0483s00.getAnoexp083() != null) {
			where.append(" AND t1.ANOEXP_083 = ?");
			params.add(ab0483s00.getAnoexp083());
		}
		if (ab0483s00 != null && ab0483s00.getNumexp083() != null) {
			where.append(" AND t1.NUMEXP_083 = ?");
			params.add(ab0483s00.getNumexp083());
		}
		if (ab0483s00 != null && ab0483s00.getTipdoc083() != null) {
			where.append(" AND t1.TIPDOC_083 = ?");
			params.add(ab0483s00.getTipdoc083());
		}
		if (ab0483s00 != null && ab0483s00.getNumdoc083() != null) {
			where.append(" AND t1.NUMDOC_083 = ?");
			params.add(ab0483s00.getNumdoc083());
		}
		if (ab0483s00 != null && ab0483s00.getFecalt083() != null) {
			where.append(" AND t1.FECALT_083 = ?");
			params.add(ab0483s00.getFecalt083());
		}
		if (ab0483s00 != null && ab0483s00.getCodobra083() != null) {
			where.append(" AND t1.CODOBRA_083 = ?");
			params.add(ab0483s00.getCodobra083());
		}
		if (ab0483s00 != null && ab0483s00.getFecbaj083() != null) {
			where.append(" AND (t1.FECBAJ_083 = ?) ");
			params.add(ab0483s00.getFecbaj083());
		} else {
			where.append(" AND t1.FECBAJ_083 IS NULL ");
		}
		if (ab0483s00 != null && ab0483s00.getNompry083() != null) {
			where.append(" AND t1.NOMPRY_083 = ?");
			params.add(ab0483s00.getNompry083());
		}
		if (ab0483s00 != null && ab0483s00.getPaispry083() != null) {
			where.append(" AND t1.PAISPRY_083 = ?");
			params.add(ab0483s00.getPaispry083());
		}
		if (ab0483s00 != null && ab0483s00.getPrvpry083() != null) {
			where.append(" AND t1.PRVPRY_083 = ?");
			params.add(ab0483s00.getPrvpry083());
		}
		if (ab0483s00 != null && ab0483s00.getMunpry083() != null) {
			where.append(" AND t1.MUNPRY_083 = ?");
			params.add(ab0483s00.getMunpry083());
		}
		if (ab0483s00 != null && ab0483s00.getDmunpry083() != null) {
			where.append(" AND t1.DMUNPRY_083 = ?");
			params.add(ab0483s00.getDmunpry083());
		}
		if (ab0483s00 != null && ab0483s00.getDirpry083() != null) {
			where.append(" AND t1.DIRPRY_083 = ?");
			params.add(ab0483s00.getDirpry083());
		}
		if (ab0483s00 != null && ab0483s00.getCpopry083() != null) {
			where.append(" AND t1.CPOPRY_083 = ?");
			params.add(ab0483s00.getCpopry083());
		}
		if (ab0483s00 != null && ab0483s00.getOrdexp083() != null) {
			where.append(" AND t1.ORDEXP_083 = ?");
			params.add(ab0483s00.getOrdexp083());
		}
		if (ab0483s00 != null && ab0483s00.getUsualt083() != null) {
			where.append(" AND t1.USUALT_083 = ?");
			params.add(ab0483s00.getUsualt083());
		}
		if (ab0483s00 != null && ab0483s00.getFecmod083() != null) {
			where.append(" AND t1.FECMOD_083 = ?");
			params.add(ab0483s00.getFecmod083());
		}
		if (ab0483s00 != null && ab0483s00.getUsumod083() != null) {
			where.append(" AND t1.USUMOD_083 = ?");
			params.add(ab0483s00.getUsumod083());
		}
		if (ab0483s00 != null && ab0483s00.getDescpry083() != null) {
			where.append(" AND t1.DESCPRY_083 = ?");
			params.add(ab0483s00.getDescpry083());
		}
		if (ab0483s00 != null && ab0483s00.getTlfpry083() != null) {
			where.append(" AND t1.TLFPRY_083 = ?");
			params.add(ab0483s00.getTlfpry083());
		}
		if (ab0483s00 != null && ab0483s00.getEmailpry083() != null) {
			where.append(" AND t1.EMAILPRY_083 = ?");
			params.add(ab0483s00.getEmailpry083());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0483s00 entity.
	 * 
	 *  ab0483s00            Ab0483s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Proyectista ab0483s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ProyectistaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0483s00 != null && ab0483s00.getTerexp083() != null) {
			where.append(" AND UPPER(t1.TEREXP_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getTerexp083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getTerexp083().toUpperCase() + "%");
			}
			where.append(" AND t1.TEREXP_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getAnoexp083() != null) {
			where.append(" AND UPPER(t1.ANOEXP_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getAnoexp083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getAnoexp083().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOEXP_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getNumexp083() != null) {
			where.append(" AND t1.NUMEXP_083 = ?");
			params.add(ab0483s00.getNumexp083());
		}
		if (ab0483s00 != null && ab0483s00.getTipdoc083() != null) {
			where.append(" AND UPPER(t1.TIPDOC_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getTipdoc083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getTipdoc083().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getNumdoc083() != null) {
			where.append(" AND UPPER(t1.NUMDOC_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getNumdoc083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getNumdoc083().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getFecalt083() != null) {
			where.append(" AND t1.FECALT_083 = ?");
			params.add(ab0483s00.getFecalt083());
		}
		if (ab0483s00 != null && ab0483s00.getCodobra083() != null) {
			where.append(" AND t1.CODOBRA_083 = ?");
			params.add(ab0483s00.getCodobra083());
		}
		if (ab0483s00 != null && ab0483s00.getFecbaj083() != null) {
			where.append(" AND t1.FECBAJ_083 = ?");
			params.add(ab0483s00.getFecbaj083());
		}
		if (ab0483s00 != null && ab0483s00.getNompry083() != null) {
			where.append(" AND UPPER(t1.NOMPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getNompry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getNompry083().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getPaispry083() != null) {
			where.append(" AND UPPER(t1.PAISPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getPaispry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getPaispry083().toUpperCase() + "%");
			}
			where.append(" AND t1.PAISPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getPrvpry083() != null) {
			where.append(" AND UPPER(t1.PRVPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getPrvpry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getPrvpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getMunpry083() != null) {
			where.append(" AND UPPER(t1.MUNPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getMunpry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getMunpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getDmunpry083() != null) {
			where.append(" AND UPPER(t1.DMUNPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getDmunpry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getDmunpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getDirpry083() != null) {
			where.append(" AND UPPER(t1.DIRPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getDirpry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getDirpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getCpopry083() != null) {
			where.append(" AND UPPER(t1.CPOPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getCpopry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getCpopry083().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getOrdexp083() != null) {
			where.append(" AND t1.ORDEXP_083 = ?");
			params.add(ab0483s00.getOrdexp083());
		}
		if (ab0483s00 != null && ab0483s00.getUsualt083() != null) {
			where.append(" AND UPPER(t1.USUALT_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getUsualt083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getUsualt083().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getFecmod083() != null) {
			where.append(" AND t1.FECMOD_083 = ?");
			params.add(ab0483s00.getFecmod083());
		}
		if (ab0483s00 != null && ab0483s00.getUsumod083() != null) {
			where.append(" AND UPPER(t1.USUMOD_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getUsumod083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getUsumod083().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getDescpry083() != null) {
			where.append(" AND UPPER(t1.DESCPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getDescpry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getDescpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getTlfpry083() != null) {
			where.append(" AND UPPER(t1.TLFPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getTlfpry083().toUpperCase() + "%");
			} else {
				params.add("%" + ab0483s00.getTlfpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFPRY_083 IS NOT NULL");
		}
		if (ab0483s00 != null && ab0483s00.getEmailpry083() != null) {
			where.append(" AND UPPER(t1.EMAILPRY_083) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0483s00.getEmailpry083().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0483s00.getEmailpry083().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAILPRY_083 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
